#!/usr/bin/env bash
#/***********************************************************************
# Freeciv - Copyright (C) 2017-2025
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#***********************************************************************/

SRCDIR="$(cd $(dirname $0) ; pwd)"
TOP_SRCDIR="$(cd ${SRCDIR}/.. ; pwd)"

(
  echo "# Generated by generate_rs_save.sh."
  echo
  echo "# rulesets_save.sh [ruleset]..."
  echo "# Exits with 0 when each specified ruleset or,"
  echo "# if no rulesets are specified, each ruleset that"
  echo "# is developed with Freeciv, can be saved using ruleup."
  echo "# Exits with 1 if not."
  echo "# If KEEP_RESULT_IN_DIR is set to a folder the saved result"
  echo "# will be kept there for later inspection even if"
  echo "# nothing fails."
  echo
  echo "if test \"\$1\" = \"\" ; then"
  echo "  # Try to save all rulesets that are developed with Freeciv"
  echo "  rulesets=\"\$(cat ${SRCDIR}/rs_test_res/ruleset_list_dist.txt)\""
  echo "  optional=\"\$(cat ${SRCDIR}/rs_test_res/ruleset_list_opt.txt)\""
  echo "  for opt in \${optional} ; do"
  echo "    if test -d \"${TOP_SRCDIR}/data/\${opt}\" ; then"
  echo "      rulesets=\"\${rulesets} \${opt}\""
  echo "    fi"
  echo "  done"
  echo "else"
  echo "  # Try to save the specified ruleset(s)"
  echo "  rulesets=\$@"
  echo "fi"
  echo
  echo "tmpdir=\"\$(mktemp -d)\""
  echo
  echo "if test -d \"\${tmpdir}\" ; then"
  echo "  cp -R \"${TOP_SRCDIR}/data/ruledit/\" \"\${tmpdir}\" || exit 1"
  echo "  cp -R \"${TOP_SRCDIR}/data/default/\" \"\${tmpdir}\" || exit 1"
  echo "else"
  echo "  echo \"Unable to create folder for temporary files: \\\"\${tmpdir}\\\"\""
  echo "  exit 1"
  echo "fi"
  echo
  echo "for ruleset in \${rulesets}; do"
  echo "  resaved=\"rs_\${ruleset}_resaved\""
  echo "  resaved_path=\"\${tmpdir}/\${resaved}\""
  echo "  reresaved=\"resaved_rs_\${ruleset}\""
  echo "  reresaved_path=\"\${tmpdir}/\${reresaved}\""
  echo
  echo "  echo \"Loading \${ruleset} and saving it as \${resaved}\""
  echo "  ./run.sh freeciv-ruleup -F -c -r \${ruleset} \\"
  echo "           --output \"\${resaved_path}\" \\"
  echo "  || exit 1"
  echo
  echo "  echo \"Trying to load \${ruleset} saved as \${resaved}\""
  echo "  FREECIV_DATA_PATH=\"\${tmpdir}\" \\"
  echo "    ./ruleset_loads.sh \"\${resaved}\" \\"
  echo "  || exit 1"
  echo
  echo "  echo \"Checking ruleset saving stability for \${ruleset}\""
  echo
  echo "  echo \"Resaving resaved \${ruleset}\""
  echo "  FREECIV_DATA_PATH=\"\${tmpdir}\" \\"
  echo "    ./run.sh freeciv-ruleup -F -c -r \${resaved} \\"
  echo "           --output \"\${reresaved_path}\" \\"
  echo "  || exit 1"
  echo "  if ! test -d \"\${reresaved_path}\" ; then"
  echo "    echo \"Missing \${reresaved_path} means that resaving must have failed.\""
  echo "    exit 1"
  echo "  fi"
  echo "  result=\"\$(diff -u \"\${resaved_path}\" \"\${reresaved_path}\")\""
  echo "  if test \"\${result}\" != \"\" ; then"
  echo "    echo \"\${result}\""
  echo "    echo \"Unstable ruleset saving.\""
  echo "    exit 1"
  echo "  fi"
  echo "done"
  echo
  echo "rm -Rf \"\${tmpdir}\""
  echo
  echo "echo \"No resaving problems detected.\""
  echo
  echo "exit 0"
) > $1

chmod +x "$1"
