#!/usr/bin/env bash
#/***********************************************************************
# Freeciv - Copyright (C) 2017-2025
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#***********************************************************************/

SRCDIR="$(cd $(dirname $0) ; pwd)"

(
  echo "# Generated by generate_rs_not_broken.sh."
  echo
  echo "# rulesets_not_broken.sh [ruleset]..."
  echo "# Exits with 0 when each specified ruleset or,"
  echo "# if no rulesets are specified, each ruleset that "
  echo "# is developed with Freeciv, are able to load."
  echo "# Exits with 1 if any ruleset fails to load."
  echo
  echo "if test \"\$1\" = \"\" ; then"
  echo "  # Try to load all rulesets that are developed with Freeciv"
  echo "  rulesets=\"\$(cat ${SRCDIR}/rs_test_res/ruleset_list_dist.txt)\""
  echo "  optional=\"\$(cat ${SRCDIR}/rs_test_res/ruleset_list_opt.txt)\""
  echo "  for opt in \$optional ; do"
  echo "    if test -d \"${SRCDIR}/../data/\$opt\" ; then"
  echo "      rulesets=\"\$rulesets \$opt\""
  echo "    fi"
  echo "  done"
  echo "else"
  echo "  # Try to load the specified ruleset(s)"
  echo "  rulesets=\$@"
  echo "fi"
  echo
  echo "for ruleset in \$rulesets; do"
  echo "  echo \"Loading \$ruleset\""
  echo "  ./ruleset_loads.sh \$ruleset || exit 1"
  echo "done"
  echo
  echo "echo \"No broken rulesets detected.\""
  echo
  echo "exit 0"
) > $1

chmod +x "$1"
