
#include "freeciv_config.h"
#include "version_gen.h"

/* This header file is shipped in some binary distributions.
 * It is included purely for reference as to how the executables were built,
 * and changing it will have no functional effect on pre-built binaries. */

#define MESON_BUILD

#define LOCALEDIR "./share/locale"

#define BUG_URL "https://redmine.freeciv.org/projects/freeciv"
#define HOMEPAGE_URL "https://www.freeciv.org/"

#define DATASUBDIR "dev"

#define AI_MOD_DEFAULT "classic"

#define AI_MOD_STATIC_CLASSIC 1
#define AI_MOD_STATIC_TEX 1
/* #undef AI_MOD_STATIC_STUB */

/* Enable AI modules */
/* #undef AI_MODULES */

/* Directory to search AI modules from */
/* #undef AI_MODULEDIR */

#define DEFAULT_SOCK_PORT 5556

#define INIT_BRACE_BEGIN {
#define INIT_BRACE_END   }

#define DEFAULT_DATA_PATH ".;data;~\\.freeciv/dev;/build/meson/install/freeciv-3.3.90.10-dev-win64-gtk4/share/freeciv"
#define DEFAULT_SAVE_PATH ".;~\\.freeciv/saves"
#define DEFAULT_SCENARIO_PATH ".;data/scenarios;~\\.freeciv/dev/scenarios;~\\.freeciv/scenarios;/build/meson/install/freeciv-3.3.90.10-dev-win64-gtk4/share/freeciv/scenarios"

#define MPICON_PATH "/build/meson/install/freeciv-3.3.90.10-dev-win64-gtk4/share/freeciv/misc/mpicon.png"

#define BINDIR "/build/meson/install/freeciv-3.3.90.10-dev-win64-gtk4/bin"

#define FC_CONF_PATH "/build/meson/install/freeciv-3.3.90.10-dev-win64-gtk4/etc/freeciv"

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

/* Processor stores words with the most significant byte first */
/* #undef WORDS_BIGENDIAN */

/* Size of int type */
#define SIZEOF_INT 4

/* Database backend available */
#define HAVE_FCDB 1

/* Have Sqlite3 database backend */
#define HAVE_FCDB_SQLITE3 1

/* Build in Qt6x mode */
/* #undef FC_QT6X_MODE */

/* Release cycle information */
#define IS_DEVEL_VERSION 1
#define IS_FREEZE_VERSION 0
#define IS_BETA_VERSION 0
#define FREECIV_RELEASE_MONTH 0
#define NEXT_STABLE_VERSION "3.4.0"

/* Produce debug version */
#define FREECIV_DEBUG 1

/* Enable audio */
#define AUDIO_SDL 1

/* Use SDL3_mixer */
/* #undef AUDIO_SDL3 */

/* Native language support enabled */
#define ENABLE_NLS 1

/* Include git commit id to version string */
/* #undef GITREV */

/* Format specifier for size_t */
#define SIZE_T_PRINTF "%lld"

/* Can run programs as root */
#define ALWAYS_ROOT 1

/* Development version save game compatibility */
/* #undef FREECIV_DEV_SAVE_COMPAT */

#ifdef FREECIV_DEV_SAVE_COMPAT
/* Current development versions */
#define FREECIV_DEV_SAVE_COMPAT_3_4
#define FREECIV_DEV_SAVE_COMPAT_3_3
#endif /* FREECIV_DEV_SAVE_COMPAT */

/* Have magickwand mapimg toolkit */
#define HAVE_MAPIMG_MAGICKWAND 1

/* struct ip_mreqn available */
/* #undef HAVE_IP_MREQN */

/* arpa/inet.h available */
/* #undef HAVE_ARPA_INET_H */

/* bcrypt.h available */
#define HAVE_BCRYPT_H 1

/* bzlib.h available */
/* #undef HAVE_BZLIB_H */

/* direct.h available */
#define HAVE_DIRECT_H 1

/* dlfcn.h available */
/* #undef HAVE_DLFCN_H */

/* execinfo.h available */
/* #undef HAVE_EXECINFO_H */

/* fcntl.h available */
#define HAVE_FCNTL_H 1

/* time.h available */
#define HAVE_TIME_H 1

/* libcharset.h and locale_charset() available */
#define HAVE_LIBCHARSET 1

/* libgen.h available */
#define HAVE_LIBGEN_H 1

/* lzma.h available */
#define HAVE_LZMA_H 1

/* zstd.h available */
#define HAVE_ZSTD_H 1

/* memory.h available */
#define HAVE_MEMORY_H 1

/* netdb.h available */
/* #undef HAVE_NETDB_H */

/* pwd.h available */
/* #undef HAVE_PWD_H */

/* signal.h available */
#define HAVE_SIGNAL_H 1

/* stdlib.h available */
#define HAVE_STDLIB_H 1

/* strings.h available */
#define HAVE_STRINGS_H 1

/* string.h available */
#define HAVE_STRING_H 1

/* sys/file.h available */
#define HAVE_SYS_FILE_H 1

/* sys/ioctl.h available */
/* #undef HAVE_SYS_IOCTL_H */

/* sys/random.h available */
/* #undef HAVE_SYS_RANDOM_H */

/* sys/signal.h available */
/* #undef HAVE_SYS_SIGNAL_H */

/* sys/stat.h available */
#define HAVE_SYS_STAT_H 1

/* sys/termio.h available */
/* #undef HAVE_SYS_TERMIO_H */

/* sys/uio.h available */
/* #undef HAVE_SYS_UIO_H */

/* sys/utsname.h available */
/* #undef HAVE_SYS_UTSNAME_H */

/* sys/wait.h available */
/* #undef HAVE_SYS_WAIT_H */

/* termios.h available */
/* #undef HAVE_TERMIOS_H */

/* vfork.h available */
/* #undef HAVE_VFORK_H */

/* locale.h available */
#define HAVE_LOCALE_H 1

/* libintl.h available */
#define HAVE_LIBINTL_H 1

/* inttypes.h available */
#define HAVE_INTTYPES_H 1

/* stdint.h available */
#define HAVE_STDINT_H 1

/* ws2tcpip.h available */
#define HAVE_WS2TCPIP_H 1

/* sys/types.h available */
#define HAVE_SYS_TYPES_H 1

/* unistd.h available */
#define HAVE_UNISTD_H 1

/* sys/time.h available */
#define HAVE_SYS_TIME_H 1

/* sys/socket.h available */
/* #undef HAVE_SYS_SOCKET_H */

/* sys/select.h available */
/* #undef HAVE_SYS_SELECT_H */

/* netinet/in.h available */
/* #undef HAVE_NETINET_IN_H */

/* dirent.h available */
#define HAVE_DIRENT_H 1

/* stdbool.h available */
#define HAVE_STDBOOL_H 1

/* fork() available */
#define HAVE_FORK 1

/* vfork() available */
/* #undef HAVE_VFORK */

#ifdef HAVE_FORK
/* fork() is assumed to be a working one when available at all */
#define HAVE_WORKING_FORK 1
#endif

#ifdef HAVE_VFORK
/* vfork() is assumed to be a working one when available at all */
#define HAVE_WORKING_VFORK 1
#endif

/* Define if there's vsnprintf function at all */
#define HAVE_VSNPRINTF 1

#ifdef HAVE_VSNPRINTF
/* Define if the version of the 'vsnprintf' function honours the
   size argument and has a proper return value. */
/* #undef HAVE_WORKING_VSNPRINTF */
#endif

/* iconv() available */
#define HAVE_ICONV 1

/* Defined to 'const' if iconv uses that */
#define ICONV_CONST

/* backtrace() available */
/* #undef HAVE_BACKTRACE */

/* bind() available */
#define HAVE_BIND 1

/* <bzlib.h> header available */
/* #undef HAVE_BZLIB_H */

/* clock_gettime() available */
/* #undef HAVE_CLOCK_GETTIME */

/* connect() available */
#define HAVE_CONNECT 1

/* fdopen() available */
#define HAVE_FDOPEN 1

/* fopen_s() available */
#define HAVE_FOPEN_S 1

/* fileno() available */
#define HAVE_FILENO 1

/* flock() available */
/* #undef HAVE_FLOCK */

/* gettimeofday() available */
#define HAVE_GETTIMEOFDAY 1

/* ftime() available */
#define HAVE_FTIME 1

/* getaddrinfo() available */
#define HAVE_GETADDRINFO 1

/* getentropy() available */
/* #undef HAVE_GETENTROPY */

#ifdef HAVE_BCRYPT_H
/* BCryptGenRandom() available */
#define HAVE_BCRYPTGENRANDOM 1
#endif

/* gethostbyname() available */
#define HAVE_GETHOSTBYNAME 1

/* getline() available */
/* #undef HAVE_GETLINE */

/* getnameinfo() available */
#define HAVE_GETNAMEINFO 1

/* getpwuid() available */
/* #undef HAVE_GETPWUID */

/* gmtime_r() available */
/* #undef HAVE_GMTIME_R */

/* inet_aton() available */
/* #undef HAVE_INET_ATON */

/* inet_ntop() available */
#define HAVE_INET_NTOP 1

/* inet_pton() available */
#define HAVE_INET_PTON 1

/* opendir() available */
#define HAVE_OPENDIR 1

/* pclose() available */
/* #undef HAVE_PCLOSE */

/* popen() available */
/* #undef HAVE_POPEN */

/* putenv() available */
#define HAVE_PUTENV 1

/* getcwd() available */
#define HAVE_GETCWD 1

/* select() available */
#define HAVE_SELECT 1

/* setenv() available */
/* #undef HAVE_SETENV */

/* snooze() available */
/* #undef HAVE_SNOOZE */

/* strcasecoll() available */
/* #undef HAVE_STRCASECOLL */

/* strcasestr() available */
/* #undef HAVE_STRCASESTR */

/* strcoll() available */
#define HAVE_STRCOLL 1

/* strerror() available */
#define HAVE_STRERROR 1

/* stricoll() available */
#define HAVE_STRICOLL 1

/* strstr() available */
#define HAVE_STRSTR 1

/* uname() available */
/* #undef HAVE_UNAME */

/* nanosleep() available */
/* #undef HAVE_NANOSLEEP */

/* usleep() available */
#define HAVE_USLEEP 1

/* vprintf() available */
#define HAVE_VPRINTF 1

/* vsnprintf() available */
#define HAVE_VSNPRINTF 1

/* localtime_r() available */
/* #undef HAVE_LOCALTIME_R */

/* _longjmp() available */
/* #undef HAVE__LONGJMP */

/* _mkdir() available */
#define HAVE__MKDIR 1

/* _setjmp() available */
/* #undef HAVE__SETJMP */

/* _strcoll() available */
/* #undef HAVE__STRCOLL */

/* _stricoll() available */
#define HAVE__STRICOLL 1

/* fcntl() available */
/* #undef HAVE_FCNTL */

/* ioctl() available */
/* #undef HAVE_IOCTL */

#if defined(HAVE_FCNTL) || defined(HAVE_IOCTL) || defined(FREECIV_HAVE_WINSOCK)
#define NONBLOCKING_SOCKETS 1
#endif

/* Libcurl has the mime API */
#define HAVE_CURL_MIME_API 1

/* Custom path to CA cert bundle */
/* #undef CUSTOM_CACERT_PATH */

/* It's ok to call malloc() for zero bytes */
/* #undef MALLOC_ZERO_OK */
