/*
** Lua binding: common_a
*/

#include "tolua.h"

#ifndef __cplusplus
#include <stdlib.h>
#endif
#ifdef __cplusplus
 extern "C" int tolua_bnd_takeownership (lua_State* L); // from tolua_map.c
#else
 int tolua_bnd_takeownership (lua_State* L); /* from tolua_map.c */
#endif
#include <string.h>

/* Exported function */
TOLUA_API int tolua_common_a_open (lua_State* tolua_S);
LUALIB_API int luaopen_common_a (lua_State* tolua_S);

#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif
#include "api_common_intl.h"
#include "api_common_utilities.h"
#include "luascript.h"
#include "luascript_types.h"

/* function to register type */
static void tolua_reg_types (lua_State* tolua_S)
{
 tolua_usertype(tolua_S,"Nonexistent");
}

/* function: api_intl__ */
static int tolua_common_a__00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,2,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  const char* untranslated = ((const char*)  tolua_tostring(tolua_S,1,0));
 {
  const char* tolua_ret = (const char*)  api_intl__(L,untranslated);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function '_'.",&tolua_err);
 return 0;
#endif
}

/* function: api_intl_N_ */
static int tolua_common_a_N_00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,2,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  const char* untranslated = ((const char*)  tolua_tostring(tolua_S,1,0));
 {
  const char* tolua_ret = (const char*)  api_intl_N_(L,untranslated);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'N_'.",&tolua_err);
 return 0;
#endif
}

/* function: api_intl_Q_ */
static int tolua_common_a_Q_00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,2,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  const char* untranslated = ((const char*)  tolua_tostring(tolua_S,1,0));
 {
  const char* tolua_ret = (const char*)  api_intl_Q_(L,untranslated);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'Q_'.",&tolua_err);
 return 0;
#endif
}

/* function: api_intl_PL_ */
static int tolua_common_a_PL_00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isstring(tolua_S,2,0,&tolua_err) ||
 !tolua_isnumber(tolua_S,3,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,4,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  const char* singular = ((const char*)  tolua_tostring(tolua_S,1,0));
  const char* plural = ((const char*)  tolua_tostring(tolua_S,2,0));
  int n = ((int)  tolua_tonumber(tolua_S,3,0));
 {
  const char* tolua_ret = (const char*)  api_intl_PL_(L,singular,plural,n);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'PL_'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_log_base */
static int tolua_common_a_log_base00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnumber(tolua_S,1,0,&tolua_err) ||
 !tolua_isstring(tolua_S,2,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,3,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  int log_level = ((int)  tolua_tonumber(tolua_S,1,0));
  const char* message = ((const char*)  tolua_tostring(tolua_S,2,0));
 {
  api_utilities_log_base(L,log_level,message);
 }
 }
 return 0;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'base'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_deprecation_warning */
static int tolua_common_a_log_deprecation_warning00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isstring(tolua_S,2,0,&tolua_err) ||
 !tolua_isstring(tolua_S,3,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,4,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  char* method = ((char*)  tolua_tostring(tolua_S,1,0));
  char* replacement = ((char*)  tolua_tostring(tolua_S,2,0));
  char* deprecated_since = ((char*)  tolua_tostring(tolua_S,3,0));
 {
  api_utilities_deprecation_warning(L,method,replacement,deprecated_since);
 }
 }
 return 0;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'deprecation_warning'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_random */
static int tolua_common_a_random00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnumber(tolua_S,1,0,&tolua_err) ||
 !tolua_isnumber(tolua_S,2,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,3,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  int min = ((int)  tolua_tonumber(tolua_S,1,0));
  int max = ((int)  tolua_tonumber(tolua_S,2,0));
 {
  int tolua_ret = (int)  api_utilities_random(L,min,max);
 tolua_pushnumber(tolua_S,(lua_Number)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'random'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_fc_version */
static int tolua_common_a_fc_version00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnoobj(tolua_S,1,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
 {
  const char* tolua_ret = (const char*)  api_utilities_fc_version(L);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'fc_version'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_name_version */
static int tolua_common_a_name_version00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnoobj(tolua_S,1,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
 {
  const char* tolua_ret = (const char*)  api_utilities_name_version(L);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'name_version'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_comparable_version */
static int tolua_common_a_comparable_version00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnoobj(tolua_S,1,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
 {
  const char* tolua_ret = (const char*)  api_utilities_comparable_version(L);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'comparable_version'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_version_string */
static int tolua_common_a_version_string00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isnoobj(tolua_S,1,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
 {
  const char* tolua_ret = (const char*)  api_utilities_version_string(L);
 tolua_pushstring(tolua_S,(const char*)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'version_string'.",&tolua_err);
 return 0;
#endif
}

/* function: api_utilities_versions_compare */
static int tolua_common_a_versions_compare00(lua_State* tolua_S)
{
#ifndef TOLUA_RELEASE
 tolua_Error tolua_err;
 if (
 !tolua_isstring(tolua_S,1,0,&tolua_err) ||
 !tolua_isstring(tolua_S,2,0,&tolua_err) ||
 !tolua_isnoobj(tolua_S,3,&tolua_err)
 )
 goto tolua_lerror;
 else
#endif
 {
  lua_State* L =  tolua_S;
  const char* ver1 = ((const char*)  tolua_tostring(tolua_S,1,0));
  const char* ver2 = ((const char*)  tolua_tostring(tolua_S,2,0));
 {
  int tolua_ret = (int)  api_utilities_versions_compare(L,ver1,ver2);
 tolua_pushnumber(tolua_S,(lua_Number)tolua_ret);
 }
 }
 return 1;
#ifndef TOLUA_RELEASE
 tolua_lerror:
 tolua_error(tolua_S,"#ferror in function 'versions_compare'.",&tolua_err);
 return 0;
#endif
}

/* Open lib function */
LUALIB_API int luaopen_common_a (lua_State* tolua_S)
{
 tolua_open(tolua_S);
 tolua_reg_types(tolua_S);
 tolua_module(tolua_S,NULL,0);
 tolua_beginmodule(tolua_S,NULL);
 tolua_cclass(tolua_S,"Nonexistent","Nonexistent","",NULL);
 tolua_beginmodule(tolua_S,"Nonexistent");
 tolua_endmodule(tolua_S);

 { /* begin embedded lua code */
 static unsigned char B[] = {
  10,102,117,110, 99,116,105,111,110, 32, 78,111,110,101,120,
 105,115,116,101,110,116, 58,101,120,105,115,116,115, 40, 41,
  10,114,101,116,117,114,110, 32,102, 97,108,115,101, 10,101,
 110,100,32
 };
 if (luaL_loadbuffer(tolua_S,(char*)B,sizeof(B),"tolua: embedded Lua code") == LUA_OK)
 lua_pcall(tolua_S,0,LUA_MULTRET,0);
 } /* end of embedded lua code */

 tolua_function(tolua_S,"_",tolua_common_a__00);
 tolua_function(tolua_S,"N_",tolua_common_a_N_00);
 tolua_function(tolua_S,"Q_",tolua_common_a_Q_00);
 tolua_function(tolua_S,"PL_",tolua_common_a_PL_00);
 tolua_module(tolua_S,"log",0);
 tolua_beginmodule(tolua_S,"log");
 tolua_module(tolua_S,"level",0);
 tolua_beginmodule(tolua_S,"level");
 tolua_constant(tolua_S,"FATAL",LOG_FATAL);
 tolua_constant(tolua_S,"ERROR",LOG_ERROR);
 tolua_constant(tolua_S,"WARN",LOG_WARN);
 tolua_constant(tolua_S,"NORMAL",LOG_NORMAL);
 tolua_constant(tolua_S,"VERBOSE",LOG_VERBOSE);
 tolua_constant(tolua_S,"DEBUG",LOG_DEBUG);
 tolua_endmodule(tolua_S);
 tolua_function(tolua_S,"base",tolua_common_a_log_base00);
 tolua_function(tolua_S,"deprecation_warning",tolua_common_a_log_deprecation_warning00);
 tolua_endmodule(tolua_S);

 { /* begin embedded lua code */
 static unsigned char B[] = {
  10,102,117,110, 99,116,105,111,110, 32,108,111,103, 46,102,
  97,116, 97,108, 40,102,109,116, 44, 32, 46, 46, 46, 41, 10,
 108,111,103, 46, 98, 97,115,101, 40,108,111,103, 46,108,101,
 118,101,108, 46, 70, 65, 84, 65, 76, 44, 32,115,116,114,105,
 110,103, 46,102,111,114,109, 97,116, 40,102,109,116, 44, 32,
  46, 46, 46, 41, 41, 10,101,110,100, 10,102,117,110, 99,116,
 105,111,110, 32,108,111,103, 46,101,114,114,111,114, 40,102,
 109,116, 44, 32, 46, 46, 46, 41, 10,108,111,103, 46, 98, 97,
 115,101, 40,108,111,103, 46,108,101,118,101,108, 46, 69, 82,
  82, 79, 82, 44, 32,115,116,114,105,110,103, 46,102,111,114,
 109, 97,116, 40,102,109,116, 44, 32, 46, 46, 46, 41, 41, 10,
 101,110,100, 10,102,117,110, 99,116,105,111,110, 32,108,111,
 103, 46,119, 97,114,110, 40,102,109,116, 44, 32, 46, 46, 46,
  41, 10,108,111,103, 46, 98, 97,115,101, 40,108,111,103, 46,
 108,101,118,101,108, 46, 87, 65, 82, 78, 44, 32,115,116,114,
 105,110,103, 46,102,111,114,109, 97,116, 40,102,109,116, 44,
  32, 46, 46, 46, 41, 41, 10,101,110,100, 10,102,117,110, 99,
 116,105,111,110, 32,108,111,103, 46,110,111,114,109, 97,108,
  40,102,109,116, 44, 32, 46, 46, 46, 41, 10,108,111,103, 46,
  98, 97,115,101, 40,108,111,103, 46,108,101,118,101,108, 46,
  78, 79, 82, 77, 65, 76, 44, 32,115,116,114,105,110,103, 46,
 102,111,114,109, 97,116, 40,102,109,116, 44, 32, 46, 46, 46,
  41, 41, 10,101,110,100, 10,102,117,110, 99,116,105,111,110,
  32,108,111,103, 46,118,101,114, 98,111,115,101, 40,102,109,
 116, 44, 32, 46, 46, 46, 41, 10,108,111,103, 46, 98, 97,115,
 101, 40,108,111,103, 46,108,101,118,101,108, 46, 86, 69, 82,
  66, 79, 83, 69, 44, 32,115,116,114,105,110,103, 46,102,111,
 114,109, 97,116, 40,102,109,116, 44, 32, 46, 46, 46, 41, 41,
  10,101,110,100, 10,102,117,110, 99,116,105,111,110, 32,108,
 111,103, 46,100,101, 98,117,103, 40,102,109,116, 44, 32, 46,
  46, 46, 41, 10,108,111,103, 46, 98, 97,115,101, 40,108,111,
 103, 46,108,101,118,101,108, 46, 68, 69, 66, 85, 71, 44, 32,
 115,116,114,105,110,103, 46,102,111,114,109, 97,116, 40,102,
 109,116, 44, 32, 46, 46, 46, 41, 41, 10,101,110,100, 10,102,
 117,110, 99,116,105,111,110, 32,101,114,114,111,114, 95,108,
 111,103, 40,109,115,103, 41, 10,108,111,103, 46,100,101,112,
 114,101, 99, 97,116,105,111,110, 95,119, 97,114,110,105,110,
 103, 40, 34,101,114,114,111,114, 95,108,111,103, 40, 41, 34,
  44, 32, 34,108,111,103, 46,101,114,114,111,114, 40, 41, 34,
  44, 32, 34, 50, 46, 52, 34, 41, 59, 10,108,111,103, 46,101,
 114,114,111,114, 40,109,115,103, 41, 10,101,110,100, 10,102,
 117,110, 99,116,105,111,110, 32,100,101, 98,117,103, 95,108,
 111,103, 40,109,115,103, 41, 10,108,111,103, 46,100,101,112,
 114,101, 99, 97,116,105,111,110, 95,119, 97,114,110,105,110,
 103, 40, 34,100,101, 98,117,103, 95,108,111,103, 40, 41, 34,
  44, 32, 34,108,111,103, 46,100,101, 98,117,103, 40, 41, 34,
  44, 32, 34, 50, 46, 52, 34, 41, 59, 10,108,111,103, 46,100,
 101, 98,117,103, 40,109,115,103, 41, 10,101,110,100,32
 };
 if (luaL_loadbuffer(tolua_S,(char*)B,sizeof(B),"tolua: embedded Lua code") == LUA_OK)
 lua_pcall(tolua_S,0,LUA_MULTRET,0);
 } /* end of embedded lua code */

 tolua_function(tolua_S,"random",tolua_common_a_random00);
 tolua_function(tolua_S,"fc_version",tolua_common_a_fc_version00);
 tolua_function(tolua_S,"name_version",tolua_common_a_name_version00);
 tolua_function(tolua_S,"comparable_version",tolua_common_a_comparable_version00);
 tolua_function(tolua_S,"version_string",tolua_common_a_version_string00);
 tolua_function(tolua_S,"versions_compare",tolua_common_a_versions_compare00);

 { /* begin embedded lua code */
 static unsigned char B[] = {
  10,102,117,110, 99,116,105,111,110, 32, 95,102,114,101,101,
  99,105,118, 95,115,116, 97,116,101, 95,100,117,109,112, 40,
  41, 10,108,111, 99, 97,108, 32,114,101,115, 32, 61, 32, 39,
  39, 10,102,111,114, 32,107, 44, 32,118, 32,105,110, 32,112,
  97,105,114,115, 40, 95, 71, 41, 32,100,111, 10,105,102, 32,
 107, 32, 61, 61, 32, 39, 95, 86, 69, 82, 83, 73, 79, 78, 39,
  32,116,104,101,110, 10,101,108,115,101,105,102, 32,116,121,
 112,101, 40,118, 41, 32, 61, 61, 32, 39, 98,111,111,108,101,
  97,110, 39, 10,111,114, 32,116,121,112,101, 40,118, 41, 32,
  61, 61, 32, 39,110,117,109, 98,101,114, 39, 32,116,104,101,
 110, 10,108,111, 99, 97,108, 32,114,118, 97,108,117,101, 32,
  61, 32,116,111,115,116,114,105,110,103, 40,118, 41, 10,114,
 101,115, 32, 61, 32,114,101,115, 32, 46, 46, 32,107, 32, 46,
  46, 32, 39, 61, 39, 32, 46, 46, 32,114,118, 97,108,117,101,
  32, 46, 46, 32, 39, 92,110, 39, 10,101,108,115,101,105,102,
  32,116,121,112,101, 40,118, 41, 32, 61, 61, 32, 39,115,116,
 114,105,110,103, 39, 32,116,104,101,110, 10,108,111, 99, 97,
 108, 32,114,118, 97,108,117,101, 32, 61, 32,115,116,114,105,
 110,103, 46,102,111,114,109, 97,116, 40, 39, 37,113, 39, 44,
  32,118, 41, 10,114,101,115, 32, 61, 32,114,101,115, 32, 46,
  46, 32,107, 32, 46, 46, 32, 39, 61, 39, 32, 46, 46, 32,114,
 118, 97,108,117,101, 32, 46, 46, 32, 39, 92,110, 39, 10,101,
 108,115,101,105,102, 32,116,121,112,101, 40,118, 41, 32, 61,
  61, 32, 39,117,115,101,114,100, 97,116, 97, 39, 32,116,104,
 101,110, 10,108,111, 99, 97,108, 32,109,101,116,104,111,100,
  32, 61, 32,115,116,114,105,110,103, 46,108,111,119,101,114,
  40,116,111,108,117, 97, 46,116,121,112,101, 40,118, 41, 41,
  10,114,101,115, 32, 61, 32,114,101,115, 32, 46, 46, 32,107,
  32, 46, 46, 32, 39, 61,102,105,110,100, 46, 39, 32, 46, 46,
  32,109,101,116,104,111,100, 10,105,102, 32,109,101,116,104,
 111,100, 32, 61, 61, 32, 39, 99,105,116,121, 39, 32,111,114,
  32,109,101,116,104,111,100, 32, 61, 61, 32, 39,117,110,105,
 116, 39, 32,116,104,101,110, 10,114,101,115, 32, 61, 32,114,
 101,115, 32, 46, 46, 32, 39, 40,110,105,108, 44, 39, 32, 46,
  46, 32,115,116,114,105,110,103, 46,102,111,114,109, 97,116,
  40, 34, 37,100, 34, 44, 32,118, 46,105,100, 41, 32, 46, 46,
  32, 39, 41, 39, 10,101,108,115,101,105,102, 32,116,121,112,
 101, 40,118, 46,114,117,108,101, 95,110, 97,109,101, 41, 32,
  61, 61, 32, 39,102,117,110, 99,116,105,111,110, 39, 32,116,
 104,101,110, 10,114,101,115, 32, 61, 32,114,101,115, 32, 46,
  46, 32, 39, 40, 39, 32, 46, 46, 32,115,116,114,105,110,103,
  46,102,111,114,109, 97,116, 40, 34, 39, 37,115, 39, 34, 44,
  32,118, 46,114,117,108,101, 95,110, 97,109,101, 40,118, 41,
  41, 32, 46, 46, 32, 39, 41, 39, 10,101,108,115,101,105,102,
  32,116,121,112,101, 40,118, 46,110, 97,109,101, 41, 32, 61,
  61, 32, 39,102,117,110, 99,116,105,111,110, 39, 32,116,104,
 101,110, 10,114,101,115, 32, 61, 32,114,101,115, 32, 46, 46,
  32, 39, 40, 39, 32, 46, 46, 32,115,116,114,105,110,103, 46,
 102,111,114,109, 97,116, 40, 34, 39, 37,115, 39, 34, 44, 32,
 118, 46,110, 97,109,101, 40,118, 41, 41, 32, 46, 46, 32, 39,
  41, 39, 10,101,108,115,101,105,102, 32,118, 46,110, 97,109,
 101, 32,126, 61, 32,110,105,108, 32,116,104,101,110, 10,114,
 101,115, 32, 61, 32,114,101,115, 32, 46, 46, 32, 39, 40, 39,
  32, 46, 46, 32,115,116,114,105,110,103, 46,102,111,114,109,
  97,116, 40, 34, 39, 37,115, 39, 34, 44, 32,118, 46,110, 97,
 109,101, 41, 32, 46, 46, 32, 39, 41, 39, 10,101,108,115,101,
 105,102, 32,118, 46,105,100, 32,116,104,101,110, 10,114,101,
 115, 32, 61, 32,114,101,115, 32, 46, 46, 32, 39, 40, 39, 32,
  46, 46, 32,115,116,114,105,110,103, 46,102,111,114,109, 97,
 116, 40, 34, 37,100, 34, 44, 32,118, 46,105,100, 41, 32, 46,
  46, 32, 39, 41, 39, 10,101,108,115,101, 10,114,101,115, 32,
  61, 32,114,101,115, 32, 46, 46, 32, 39, 40, 41, 39, 10,101,
 110,100, 10,114,101,115, 32, 61, 32,114,101,115, 32, 46, 46,
  32, 39, 92,110, 39, 10,101,110,100, 10,101,110,100, 10,114,
 101,116,117,114,110, 32,114,101,115, 10,101,110,100, 10,102,
 117,110, 99,116,105,111,110, 32,108,105,115,116,101,110,118,
  40, 41, 10,102, 99,101, 40, 95, 71, 41, 10,101,110,100, 10,
 102,117,110, 99,116,105,111,110, 32,102, 99,101, 40,100, 97,
 116,117,109, 44, 32,100,101,112,116,104, 44, 32,112,114,101,
 102,105,120, 44, 32,115,116,114,105,110,103, 95,112, 97,114,
 115,101, 41, 10,108,111, 99, 97,108, 32,115, 32, 61, 32, 34,
  32, 37,115, 32, 34, 59, 10,108,111, 99, 97,108, 32,113, 32,
  61, 32, 34, 32, 37,113, 32, 34, 10,108,111, 99, 97,108, 32,
 102,117,110, 99,116,105,111,110, 32,113, 95,102,109,116, 32,
  40,100, 41, 32,114,101,116,117,114,110, 32, 40, 34, 37,113,
  34, 41, 58,102,111,114,109, 97,116, 40,100, 41, 32,101,110,
 100, 10,108,111, 99, 97,108, 32,102,117,110, 99,116,105,111,
 110, 32,115, 95,102,109,116, 32, 40,100, 41, 32,114,101,116,
 117,114,110, 32, 40, 34, 37,115, 34, 41, 58,102,111,114,109,
  97,116, 40,100, 41, 32,101,110,100, 10,108,111, 99, 97,108,
  32,108,105,115,116,115, 32, 61, 32,115,101,116,109,101,116,
  97,116, 97, 98,108,101, 32, 40, 32,123,125, 44, 32,123, 10,
  95, 95,105,110,100,101,120, 32, 61, 32,102,117,110, 99,116,
 105,111,110, 32, 40,116, 44, 32, 84, 41, 32,116, 91, 84, 93,
  32, 61, 32,123,110, 32, 61, 32, 48,125, 59, 32,114,101,116,
 117,114,110, 32,116, 91, 84, 93, 32,101,110,100, 59, 10,125,
  32, 41, 10,108,111, 99, 97,108, 32,102,117,110, 99,116,105,
 111,110, 32,116, 97, 98,117,108, 97,114, 32, 40,100, 97,116,
 117,109, 44, 32, 84,121,112,101, 44, 32,105,100, 41, 10,108,
 111, 99, 97,108, 32,108,105,115,116, 32, 61, 32,108,105,115,
 116,115, 32, 91, 84,121,112,101, 93, 59, 32,108,111, 99, 97,
 108, 32,105,110,120, 32, 61, 32,108,105,115,116, 32, 91,100,
  97,116,117,109, 93, 10,105,102, 32,105,110,120, 32,116,104,
 101,110, 32,114,101,116,117,114,110, 32,105,110,120, 46, 46,
  34, 61, 34, 44, 32, 84,121,112,101, 10,101,108,115,101,105,
 102, 32,105,100, 32,116,104,101,110, 32,108,105,115,116, 32,
  91,100, 97,116,117,109, 93, 32, 61, 32,105,100, 59, 32,108,
 105,115,116, 46,110, 32, 61, 32,109, 97,116,104, 46,109, 97,
 120, 40,105,100, 44, 32,108,105,115,116, 46,110, 41, 10,114,
 101,116,117,114,110, 32,105,100, 44, 32, 84,121,112,101, 44,
  32, 34, 34, 10,101,108,115,101, 32,105,110,120, 32, 61, 32,
 108,105,115,116, 46,110, 32, 43, 49, 59, 32,108,105,115,116,
  32, 91,100, 97,116,117,109, 93, 32, 61, 32,105,110,120, 59,
  32,108,105,115,116, 46,110, 32, 61, 32,105,110,120, 59, 10,
 114,101,116,117,114,110, 32,105,110,120, 44, 32, 84,121,112,
 101, 44, 32,105,110,120, 10,101,110,100, 10,101,110,100, 10,
 108,111, 99, 97,108, 32, 84, 84, 32, 61, 32,115,101,116,109,
 101,116, 97,116, 97, 98,108,101, 32, 40, 32,123, 10,110,117,
 109, 98,101,114, 32, 61, 32,102,117,110, 99,116,105,111,110,
  32, 40,100, 44, 32, 84, 41, 32,114,101,116,117,114,110, 32,
 115, 95,102,109,116, 40,100, 41, 44, 32,109, 97,116,104, 46,
 116,121,112,101, 40,100, 41, 32,101,110,100, 59, 10,115,116,
 114,105,110,103, 32, 61, 32,102,117,110, 99,116,105,111,110,
  32, 40,100, 44, 32, 84, 41, 10,108,111, 99, 97,108, 32,115,
 116,114, 44, 32, 99,111,117,110,116, 44, 32,105,110,120, 44,
  32,110,101,119, 32, 61, 32,100, 58,103,115,117, 98, 32, 40,
  34, 91, 37, 99, 92,120, 56, 48, 45, 92,120, 70, 70, 93, 34,
  44, 32, 34, 42, 34, 41, 10,105,102, 32, 99,111,117,110,116,
  32,126, 61, 32, 48, 32,116,104,101,110, 32,105,110,120, 44,
  32, 84, 44, 32,110,101,119, 32, 61, 32,116, 97, 98,117,108,
  97,114, 40,100, 44, 32, 34, 83, 84, 82, 73, 78, 71, 34, 46,
  46, 99,111,117,110,116, 41, 32,101,110,100, 10,114,101,116,
 117,114,110, 32,113, 95,102,109,116, 40,115,116,114, 41, 46,
  46, 40,105,110,120, 32, 97,110,100, 32, 34, 32, 34, 46, 46,
  32,105,110,120, 32,111,114, 32, 34, 34, 41, 44, 10,100, 58,
 102,105,110,100, 40, 34, 94, 91, 95, 37, 97, 93, 91, 95, 37,
  97, 37,100, 93, 42, 36, 34, 41, 32, 97,110,100, 32, 34,105,
 100,101,110,116,105,102,105,101,114, 34, 32,111,114, 32, 84,
  44, 10,110,105,108, 10,101,110,100, 59, 10, 91, 34,102,117,
 110, 99,116,105,111,110, 34, 93, 32, 61, 32,116, 97, 98,117,
 108, 97,114, 59, 10,116,104,114,101, 97,100, 32, 61, 32,116,
  97, 98,117,108, 97,114, 59, 10,116, 97, 98,108,101, 32, 61,
  32,116, 97, 98,117,108, 97,114, 59, 10,117,115,101,114,100,
  97,116, 97, 32, 61, 32,102,117,110, 99,116,105,111,110, 32,
  40,100, 44, 32, 84, 41, 32, 84, 32, 61, 32,116,111,108,117,
  97, 46,116,121,112,101, 40,100, 41, 59, 32,108,111, 99, 97,
 108, 32,105,100, 32, 61, 32,100, 46,105,100, 59, 10,105,102,
  32,100, 46,114,117,108,101, 95,110, 97,109,101, 32,116,104,
 101,110, 32,114,101,116,117,114,110, 40, 34, 37,115, 32, 37,
 113, 32, 34, 41, 58,102,111,114,109, 97,116, 40,105,100, 44,
 100, 58,114,117,108,101, 95,110, 97,109,101, 40, 41, 41, 44,
  84, 10,101,108,115,101, 32,114,101,116,117,114,110, 32,116,
  97, 98,117,108, 97,114, 32, 40,100, 44, 32, 84, 44, 32,105,
 100, 41, 10,101,110,100, 10,101,110,100, 59, 10,125, 44, 32,
 123, 10, 95, 95,105,110,100,101,120, 32, 61, 32,102,117,110,
  99,116,105,111,110, 32, 40, 41, 32,114,101,116,117,114,110,
  32, 40,102,117,110, 99,116,105,111,110, 32, 40,100, 44, 84,
  41, 32,114,101,116,117,114,110, 32,113, 95,102,109,116, 40,
 100, 41, 44, 84, 32,101,110,100, 41, 32,101,110,100, 59, 10,
  95, 95, 99, 97,108,108, 32, 61, 32,102,117,110, 99,116,105,
 111,110, 32, 40,116, 44, 32,100, 41, 32,108,111, 99, 97,108,
  32, 84, 32, 61, 32,116,121,112,101, 40,100, 41, 59, 32,114,
 101,116,117,114,110, 32,116, 32, 91, 84, 93, 32, 40,100, 44,
  32, 84, 41, 32,101,110,100, 59, 10,125, 32, 41, 10,108,111,
  99, 97,108, 32,109,116, 32, 61, 32, 34, 32,109,101,116, 97,
  32, 37,115, 32, 34, 10,108,111, 99, 97,108, 32,102,117,110,
  99,116,105,111,110, 32,100,111, 95,100, 97,116,117,109, 32,
  40,116,101,120,116, 44, 32,100, 97,116,117,109, 44, 32, 84,
 121,112,101, 41, 10,108,111, 99, 97,108, 32,109,101,116, 97,
  44, 32,118, 97,108, 44, 32, 84, 44, 32,110,101,119, 32, 61,
  32,103,101,116,109,101,116, 97,116, 97, 98,108,101, 32, 40,
 100, 97,116,117,109, 41, 59, 10,105,102, 32,116,121,112,101,
  40,109,101,116, 97, 41, 32,126, 61, 32, 34,110,105,108, 34,
  10,116,104,101,110, 32,118, 97,108, 44, 32, 84, 44, 32,110,
 101,119, 32, 61, 32, 84, 84, 40,109,101,116, 97, 41, 59, 32,
 116,101,120,116, 32, 61, 32,116,101,120,116, 46, 46,109,116,
  58,102,111,114,109, 97,116, 40, 84, 41, 46, 46,118, 97,108,
  10,101,110,100, 59, 10, 99,111,114,111,117,116,105,110,101,
  46,121,105,101,108,100, 32, 40,116,101,120,116, 44, 32,100,
  97,116,117,109, 44, 32, 84,121,112,101, 41, 59, 10,105,102,
  32,110,101,119, 32,116,104,101,110, 32,114,101,116,117,114,
 110, 32,109,101,116, 97, 44, 32,118, 97,108, 44, 32, 84, 32,
 101,110,100, 10,101,110,100, 10,108,111, 99, 97,108, 32,102,
 117,110, 99,116,105,111,110, 32, 99,111, 32, 40,116,101,120,
 116, 44, 32,100, 49, 44, 32,112,114,101,102,105,120, 41, 10,
 108,111, 99, 97,108, 32,118, 49, 44, 32, 84, 49, 44, 32,110,
 101,119, 32, 61, 32, 84, 84, 40,100, 49, 41, 10,108,111, 99,
  97,108, 32,100, 50, 44, 32,118, 50, 44, 32, 84, 50, 32, 61,
  10,100,111, 95,100, 97,116,117,109, 32, 40,116,101,120,116,
  46, 46, 34, 32, 40, 34, 46, 46, 84, 49, 46, 46, 34, 41, 32,
  34, 46, 46,118, 49, 44, 32,100, 49, 44, 32, 84, 49, 41, 10,
 105,102, 32,110,101,119, 32,116,104,101,110, 10, 99,111,114,
 111,117,116,105,110,101, 46,121,105,101,108,100, 32, 40,112,
 114,101,102,105,120, 46, 46,115, 58,102,111,114,109, 97,116,
  40,100, 49, 41, 46, 46,110,101,119, 44, 32,100, 49, 44, 32,
  84, 49, 41, 10,101,110,100, 10,119,104,105,108,101, 32,100,
  50, 32,100,111, 32,100, 50, 44, 32,118, 50, 44, 32, 84, 50,
  32, 61, 10,100,111, 95,100, 97,116,117,109, 32, 40,112,114,
 101,102,105,120, 46, 46,109,116, 58,102,111,114,109, 97,116,
  40,100, 50, 41, 46, 46,118, 50, 44, 32,100, 50, 44, 32, 84,
  50, 41, 10,101,110,100, 10,101,110,100, 10,108,111, 99, 97,
 108, 32,112,114,105,110,116,105,116, 32, 61, 32,108,111,103,
  46,101,114,114,111,114, 10,108,111, 99, 97,108, 32,102,117,
 110, 99,116,105,111,110, 32,112, 97,114,116, 95, 48, 32, 40,
 100, 97,116,117,109, 44, 32, 99,111, 95,116,101,120,116, 41,
  10,114,101,116,117,114,110, 32,123, 99,111, 95,116, 32, 61,
  32, 99,111,114,111,117,116,105,110,101, 46,119,114, 97,112,
  40, 99,111, 41, 59, 32,100, 97,116,117,109, 32, 61, 32,100,
  97,116,117,109, 59, 32, 99,111, 95,116,101,120,116, 32, 61,
  32, 99,111, 95,116,101,120,116, 59,125, 10,101,110,100, 10,
 108,111, 99, 97,108, 32,102,117,110, 99,116,105,111,110, 32,
 112, 97,114,116, 95, 49, 32, 40, 99,111, 95,115, 44, 32,112,
 114,101,102,105,120, 41, 10,114,101,116,117,114,110, 32, 99,
 111, 95,115, 46, 99,111, 95,116, 32, 40, 99,111, 95,115, 46,
  99,111, 95,116,101,120,116, 44, 32, 99,111, 95,115, 46,100,
  97,116,117,109, 44, 32,112,114,101,102,105,120, 41, 10,101,
 110,100, 10,108,111, 99, 97,108, 32,100,101,116, 97,105,108,
 115, 10,108,111, 99, 97,108, 32,102,117,110, 99,116,105,111,
 110, 32,112, 97,114,116, 95,120, 32, 40, 99,111, 95,115,115,
  44, 32,100,101,112,116,104, 44, 32,112,114,101,102,105,120,
  41, 10,108,111, 99, 97,108, 32,116,101,120,116, 44, 32,115,
 101,112, 32, 61, 32,112,114,101,102,105,120, 44, 32, 34, 34,
  10,102,111,114, 32, 99, 44, 32, 99,111, 95,115, 32,105,110,
  32,105,112, 97,105,114,115, 32, 40, 99,111, 95,115,115, 41,
  10,100,111, 32,116,101,120,116, 44, 32,115,101,112, 32, 61,
  32,116,101,120,116, 46, 46,115,101,112, 46, 46,112, 97,114,
 116, 95, 49, 32, 40, 99,111, 95,115, 44, 32,112,114,101,102,
 105,120, 41, 44, 32, 34, 59, 32, 34, 10,101,110,100, 59, 32,
 112,114,105,110,116,105,116, 32, 40,116,101,120,116, 41, 10,
 102,111,114, 32, 99, 44, 32, 99,111, 95,115, 32,105,110, 32,
 105,112, 97,105,114,115, 32, 40, 99,111, 95,115,115, 41, 32,
 100,111, 10,102,111,114, 32,116,101,120,116, 44, 32,100, 97,
 116,117,109, 44, 32, 84,121,112,101, 32,105,110, 32,112, 97,
 114,116, 95, 49, 44, 32, 99,111, 95,115, 44, 32, 34, 34, 32,
 100,111, 10,100,101,116, 97,105,108,115, 32, 91, 84,121,112,
 101, 93, 32, 40,112,114,101,102,105,120, 46, 46,116,101,120,
 116, 44, 32,100, 97,116,117,109, 44, 32,100,101,112,116,104,
  44, 32,112,114,101,102,105,120, 41, 10,101,110,100, 10,101,
 110,100, 10,101,110,100, 10,108,111, 99, 97,108, 32, 77, 70,
  32, 61, 32,109, 97,116,104, 46,102,108,111,111,114, 10,108,
 111, 99, 97,108, 32,102,117,110, 99,116,105,111,110, 32,112,
 112, 95,116,105,108,101, 32, 40,100, 41, 10,114,101,116,117,
 114,110, 32, 40, 34, 32, 40, 37,115, 44, 37,115, 41, 32, 34,
  41, 58,102,111,114,109, 97,116, 40, 32, 77, 70, 40,100, 46,
 120, 41, 44, 32, 77, 70, 40,100, 46,121, 41, 32, 41, 10,101,
 110,100, 10,100,101,116, 97,105,108,115, 32, 61, 32,115,101,
 116,109,101,116, 97,116, 97, 98,108,101, 32, 40,123, 10,116,
  97, 98,108,101, 32, 61, 32,102,117,110, 99,116,105,111,110,
  32, 40,116,101,120,116, 44, 32,100, 44, 32,100,101,112,116,
 104, 44, 32,112,114,101,102,105,120, 41, 10,105,102, 32,100,
 101,112,116,104, 32, 61, 61, 32, 48, 10,116,104,101,110, 32,
 112,114,105,110,116,105,116, 32, 40,116,101,120,116, 46, 46,
  34, 32,108,105,109,105,116, 32,114,101, 97, 99,104,101,100,
  34, 41, 10,101,108,115,101, 32,112,114,105,110,116,105,116,
  32, 40,116,101,120,116, 41, 59, 32,102,111,114, 32,107,101,
 121, 44, 32,118, 97,108, 32,105,110, 32,110,101,120,116, 44,
  32,100, 44, 32,110,105,108, 32,100,111, 10,112, 97,114,116,
  95,120, 40,123, 32,112, 97,114,116, 95, 48, 32, 40,107,101,
 121, 44, 32, 34,107,101,121, 34, 41, 59, 32,112, 97,114,116,
  95, 48, 32, 40,118, 97,108, 44, 32, 34,118, 97,108,117,101,
  34, 41, 59, 32,125, 44, 10,100,101,112,116,104, 32, 45, 49,
  44, 32,112,114,101,102,105,120, 46, 46, 34, 46, 34, 41, 10,
 101,110,100, 10,101,110,100, 10,101,110,100, 59, 10,116,104,
 114,101, 97,100, 32, 61, 32,102,117,110, 99,116,105,111,110,
  32, 40,116,101,120,116, 44, 32,100, 41, 10,112,114,105,110,
 116,105,116, 32, 40,116,101,120,116, 46, 46,115, 58,102,111,
 114,109, 97,116, 40,100, 41, 46, 46, 99,111,114,111,117,116,
 105,110,101, 46,115,116, 97,116,117,115, 40,100, 41, 46, 46,
  10, 34, 32, 34, 32, 41, 10,101,110,100, 59, 10, 68,105,114,
 101, 99,116,105,111,110, 32, 61, 32,102,117,110, 99,116,105,
 111,110, 32, 40,116,101,120,116, 44, 32,100, 41, 32,101,110,
 100, 59, 10, 84,105,108,101, 32, 61, 32,102,117,110, 99,116,
 105,111,110, 32, 40,116,101,120,116, 44, 32,100, 41, 32,112,
 114,105,110,116,105,116, 32, 40,116,101,120,116, 46, 46,112,
 112, 95,116,105,108,101, 32, 40,100, 41, 32, 41, 32,101,110,
 100, 59, 10, 80,108, 97,121,101,114, 32, 61, 32,102,117,110,
  99,116,105,111,110, 32, 40,116,101,120,116, 44, 32,100, 41,
  32,112,114,105,110,116,105,116, 32, 40,116,101,120,116, 46,
  46, 40, 34, 32, 37,115, 37,115, 32, 40, 37,115, 58, 37,115,
  41, 34, 41, 58, 10,102,111,114,109, 97,116, 40, 32,100, 46,
 110, 97,116,105,111,110, 44, 32,100, 46, 97,105, 95, 99,111,
 110,116,114,111,108,108,101,100, 32, 97,110,100, 32, 34, 45,
  34, 32,111,114, 32, 34, 43, 34, 44, 10, 77, 70, 40,100, 58,
 110,117,109, 95, 99,105,116,105,101,115, 40, 41, 41, 44, 32,
  77, 70, 40,100, 58,110,117,109, 95,117,110,105,116,115, 40,
  41, 41, 41, 32, 41, 10,101,110,100, 59, 10, 67,105,116,121,
  32, 61, 32,102,117,110, 99,116,105,111,110, 32, 40,116,101,
 120,116, 44, 32,100, 41, 32,112,114,105,110,116,105,116, 32,
  40,116,101,120,116, 46, 46, 40, 34, 32, 37,113, 32, 40, 37,
 115, 41, 32, 37,115, 32, 37,115, 34, 41, 58, 10,102,111,114,
 109, 97,116, 40, 32,100, 46,110, 97,109,101, 44, 32,100, 46,
 115,105,122,101, 44, 32,100, 46,111,119,110,101,114, 44, 32,
 100, 46,116,105,108,101, 41, 46, 46,112,112, 95,116,105,108,
 101, 32, 40,100, 46,116,105,108,101, 41, 32, 41, 10,101,110,
 100, 59, 10, 85,110,105,116, 32, 61, 32,102,117,110, 99,116,
 105,111,110, 32, 40,116,101,120,116, 44, 32,100, 41, 32,112,
 114,105,110,116,105,116, 32, 40,116,101,120,116, 46, 46, 40,
  34, 32, 37,115, 44, 32, 37,115, 32, 37,115, 34, 41, 58, 10,
 102,111,114,109, 97,116, 40, 32,100, 46,117,116,121,112,101,
  44, 32,100, 46,111,119,110,101,114, 44, 32,100, 58,103,101,
 116, 95,104,111,109,101, 99,105,116,121, 40, 41, 32,111,114,
  32, 34,110,111, 32,104,111,109,101, 32, 99,105,116,121, 34,
  41, 32, 41, 10,101,110,100, 59, 10, 91, 34,102,117,110, 99,
 116,105,111,110, 34, 93, 32, 61, 32,102,117,110, 99,116,105,
 111,110, 32, 40,116,101,120,116, 44, 32,100, 41, 32,101,110,
 100, 59, 10,125, 44,123, 10, 95, 95,105,110,100,101,120, 32,
  61, 32,102,117,110, 99,116,105,111,110, 32, 40,116, 44, 32,
  84, 41, 32,114,101,116,117,114,110, 32,112,114,105,110,116,
 105,116, 32,101,110,100, 59, 10,125, 41, 10,105,102, 32,115,
 116,114,105,110,103, 95,112, 97,114,115,101, 32,116,104,101,
 110, 32,101,108,115,101, 32,116, 97, 98,117,108, 97,114, 40,
 103,101,116,109,101,116, 97,116, 97, 98,108,101, 40, 34, 34,
  41, 44, 32, 34,116, 97, 98,108,101, 34, 41, 32,101,110,100,
  10,112, 97,114,116, 95,120, 32, 40,123, 32,112, 97,114,116,
  95, 48, 32, 40,100, 97,116,117,109, 44, 32, 34,104,101, 97,
 100, 34, 32, 41,125, 44, 10,116,121,112,101, 32, 40,100,101,
 112,116,104, 41, 32, 61, 61, 32, 34,110,117,109, 98,101,114,
  34, 32, 97,110,100, 32,100,101,112,116,104, 32,111,114, 32,
  45, 49, 44, 10,116,121,112,101, 32, 40,112,114,101,102,105,
 120, 41, 32, 61, 61, 32, 34,115,116,114,105,110,103, 34, 32,
  97,110,100, 32,112,114,101,102,105,120, 32,111,114, 32, 34,
  34, 41, 10,114,101,116,117,114,110, 32,108,105,115,116,115,
  10,101,110,100, 10, 99,111,110,115,116, 32, 61, 32,123,125,
  10,108,111, 99, 97,108, 32,100, 97,116, 97, 32, 61, 32,123,
 125, 10, 99,111,110,115,116, 95,109,116, 32, 61, 32,123, 10,
  95, 95,110,101,119,105,110,100,101,120, 32, 61, 32,102,117,
 110, 99,116,105,111,110, 40, 97, 44, 98, 44, 99, 41, 10,105,
 102, 32,100, 97,116, 97, 91, 98, 93, 32, 61, 61, 32,110,105,
 108, 32,116,104,101,110, 10,105,102, 32,116,121,112,101, 40,
  99, 41, 32, 61, 61, 32, 39,116, 97, 98,108,101, 39, 32,116,
 104,101,110, 10,108,111, 99, 97,108, 32,112,114,111,120,121,
  32, 61, 32,123,125, 10,108,111, 99, 97,108, 32,109,116, 32,
  61, 32,123, 10, 95, 95,105,110,100,101,120, 32, 61, 32, 99,
  44, 10, 95, 95,110,101,119,105,110,100,101,120, 32, 61, 32,
 102,117,110, 99,116,105,111,110, 32, 40,116, 44,107, 44,118,
  41, 10,108,111,103, 46,101,114,114,111,114, 40, 91, 91, 34,
  65,116,116,101,109,112,116, 32,116,111, 32,117,112,100, 97,
 116,101, 32,114,101, 97,100, 45,111,110,108,121, 32,116, 97,
  98,108,101, 32, 39, 37,115, 39, 32,105,110,100,101,120, 32,
  39, 37,115, 39, 32, 34, 10, 34,119,105,116,104, 32, 39, 37,
 115, 39, 46, 34, 93, 93, 44, 32, 98, 44, 32,116,111,115,116,
 114,105,110,103, 40,107, 41, 44, 32,116,111,115,116,114,105,
 110,103, 40,118, 41, 41, 10,101,110,100, 10,125, 10,115,101,
 116,109,101,116, 97,116, 97, 98,108,101, 40,112,114,111,120,
 121, 44, 32,109,116, 41, 10,100, 97,116, 97, 91, 98, 93, 32,
  61, 32,112,114,111,120,121, 10,101,108,115,101, 10,100, 97,
 116, 97, 91, 98, 93, 32, 61, 32, 99, 10,101,110,100, 10,101,
 108,115,101, 10,108,111,103, 46,101,114,114,111,114, 40, 34,
  73,108,108,101,103, 97,108, 32, 97,115,115,105,103,110,109,
 101,110,116, 32,116,111, 32, 99,111,110,115,116, 97,110,116,
  32, 39, 37,115, 39, 46, 34, 44, 32,116,111,115,116,114,105,
 110,103, 40, 98, 41, 41, 10,101,110,100, 10,101,110,100, 44,
  10, 95, 95,105,110,100,101,120, 32, 61, 32,102,117,110, 99,
 116,105,111,110, 40, 97, 44, 98, 41, 10,114,101,116,117,114,
 110, 32,100, 97,116, 97, 91, 98, 93, 10,101,110,100, 10,125,
  10,115,101,116,109,101,116, 97,116, 97, 98,108,101, 40, 99,
 111,110,115,116, 44, 32, 99,111,110,115,116, 95,109,116, 41,
 32
 };
 if (luaL_loadbuffer(tolua_S,(char*)B,sizeof(B),"tolua: embedded Lua code") == LUA_OK)
 lua_pcall(tolua_S,0,LUA_MULTRET,0);
 } /* end of embedded lua code */

 tolua_endmodule(tolua_S);
 return 1;
}
/* Open tolua function */
TOLUA_API int tolua_common_a_open (lua_State* tolua_S)
{
 lua_pushcfunction(tolua_S, luaopen_common_a);
 lua_pushstring(tolua_S, "common_a");
 lua_call(tolua_S, 1, 0);
 return 1;
}
